/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.abyssalcraft;

import com.shinoow.abyssalcraft.api.biome.ACBiomes;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.api.world.terrain.heighteffect.HeightEffect;
import rtg.api.world.terrain.heighteffect.HeightVariation;
import rtg.api.world.terrain.heighteffect.JitterEffect;
import rtg.api.world.terrain.heighteffect.MountainsWithPassesEffect;
import rtg.world.biome.realistic.abyssalcraft.RealisticBiomeACBase;
import rtg.world.biome.realistic.abyssalcraft.SurfaceACBase;

public class RealisticBiomeACDarklandsMountains
extends RealisticBiomeACBase {
    public static Biome biome = ACBiomes.darklands_mountains;
    public static Biome river = Biomes.field_76781_i;

    public RealisticBiomeACDarklandsMountains() {
        super(biome);
    }

    @Override
    public void initConfig() {
        this.getConfig().ALLOW_RIVERS.set(false);
        this.getConfig().ALLOW_SCENIC_LAKES.set(false);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainACDarklandsMountains(120.0f, 100.0f);
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceACDarklandsMountains(this.getConfig(), RealisticBiomeACDarklandsMountains.biome.field_76752_A, RealisticBiomeACDarklandsMountains.biome.field_76753_B, 0.2f);
    }

    public static class SurfaceACDarklandsMountains
    extends SurfaceACBase {
        private float min;
        private float sCliff = 1.5f;
        private float sHeight = 60.0f;
        private float sStrength = 65.0f;
        private float iCliff = 0.3f;
        private float iHeight = 100.0f;
        private float iStrength = 50.0f;
        private float cCliff = 1.5f;

        public SurfaceACDarklandsMountains(BiomeConfig config, IBlockState top, IBlockState fill, float minCliff) {
            super(config, top, fill);
            this.min = minCliff;
        }

        public SurfaceACDarklandsMountains(BiomeConfig config, IBlockState top, IBlockState fill, float minCliff, float stoneCliff, float stoneHeight, float stoneStrength, float snowCliff, float snowHeight, float snowStrength, float clayCliff) {
            this(config, top, fill, minCliff);
            this.sCliff = stoneCliff;
            this.sHeight = stoneHeight;
            this.sStrength = stoneStrength;
            this.iCliff = snowCliff;
            this.iHeight = snowHeight;
            this.iStrength = snowStrength;
            this.cCliff = clayCliff;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            int cliff = 0;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                if (++depth == 0) {
                    float p = simplex.noise3f((float)i / 8.0f, (float)j / 8.0f, (float)k / 8.0f) * 0.5f;
                    if (c > this.min && c > this.sCliff - ((float)k - this.sHeight) / this.sStrength + p) {
                        cliff = 1;
                    }
                    if (c > this.cCliff) {
                        cliff = 2;
                    }
                    if ((float)k > 110.0f + p * 4.0f && c < this.iCliff + ((float)k - this.iHeight) / this.iStrength + p) {
                        cliff = 3;
                    }
                    if (cliff == 1 || cliff == 2) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (cliff == 3) {
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (k < 63) {
                        if (k < 62) {
                            primer.func_177855_a(x, k, z, this.fillerBlock);
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.topBlock);
                        continue;
                    }
                    primer.func_177855_a(x, k, z, Blocks.field_150349_c.func_176223_P());
                    continue;
                }
                if (depth >= 6) continue;
                if (cliff == 1 || cliff == 2) {
                    if (rand.nextInt(3) == 0) {
                        primer.func_177855_a(x, k, z, this.hcCobble());
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (cliff == 3) {
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                primer.func_177855_a(x, k, z, Blocks.field_150346_d.func_176223_P());
            }
        }
    }

    public static class TerrainACDarklandsMountains
    extends TerrainBase {
        private float width;
        private float strength;
        private float spikeWidth = 40.0f;
        private float spikeHeight = 60.0f;
        protected HeightEffect height;

        public TerrainACDarklandsMountains(float mountainWidth, float mountainStrength) {
            this(mountainWidth, mountainStrength, 90.0f);
        }

        public TerrainACDarklandsMountains(float mountainWidth, float mountainStrength, float baseHeight) {
            this.width = mountainWidth;
            this.strength = mountainStrength;
            this.base = baseHeight;
            MountainsWithPassesEffect mountainEffect = new MountainsWithPassesEffect();
            mountainEffect.mountainHeight = this.strength;
            mountainEffect.mountainWavelength = this.width;
            mountainEffect.spikeHeight = this.spikeHeight;
            mountainEffect.spikeWavelength = this.spikeWidth;
            this.height = new JitterEffect(6.0f, 10.0f, mountainEffect);
            this.height = new JitterEffect(2.0f, 6.0f, this.height);
            HeightVariation passHeight = new HeightVariation();
            passHeight.height = 15.0f;
            passHeight.octave = 4;
            passHeight.wavelength = 70.0f;
            this.height = this.height.plus(passHeight);
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainACDarklandsMountains.riverized(this.height.added(rtgWorld, x, y) + this.base, river);
        }
    }
}

